/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.design.property.tables;

import filenet.vw.api.VWMapNode;
import filenet.vw.api.VWRouteDefinition;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.design.property.resources.VWResource;
import filenet.vw.toolkit.utils.table.VWRouteListCellRenderer;
import java.util.Vector;
import javax.swing.table.DefaultTableModel;

public final class VWRoutingConditionTableModel
extends DefaultTableModel {
    private static final int NUM_COLUMNS = 3;
    public static final int COL_ROUTE_NAME = 0;
    public static final int COL_STEP_NAME = 1;
    public static final int COL_CONDITION = 2;
    private Vector m_rowData = new Vector();
    private VWMapNode m_currentMapNode = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reinitialize(VWMapNode vwMapNode) {
        try {
            this.m_currentMapNode = vwMapNode;
            this.m_rowData.removeAllElements();
            if (vwMapNode == null) {
                return;
            }
            VWRouteDefinition[] routeDefs = vwMapNode.getNextRoutes();
            if (routeDefs != null) {
                for (int i = 0; i < routeDefs.length; ++i) {
                    this.m_rowData.addElement(routeDefs[i]);
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        finally {
            this.fireTableDataChanged();
        }
    }

    public void moveRoutesUp(int[] nSelectedRows) {
        if (nSelectedRows.length == 0) {
            return;
        }
        try {
            for (int nIndex = 0; nIndex < nSelectedRows.length; ++nIndex) {
                int nRowIndex = nSelectedRows[nIndex];
                if (nRowIndex == 0) continue;
                Object currentObj = this.m_rowData.elementAt(nRowIndex);
                Object previousObj = this.m_rowData.elementAt(nRowIndex - 1);
                this.m_rowData.setElementAt(currentObj, nRowIndex - 1);
                this.m_rowData.setElementAt(previousObj, nRowIndex);
            }
            this.updateRouteOrder();
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void moveRoutesDown(int[] nSelectedRows) {
        if (nSelectedRows.length == 0) {
            return;
        }
        try {
            for (int nIndex = nSelectedRows.length - 1; nIndex >= 0; --nIndex) {
                int nRowIndex = nSelectedRows[nIndex];
                if (nRowIndex >= this.getRowCount() - 1) continue;
                Object currentObj = this.m_rowData.elementAt(nRowIndex);
                Object previousObj = this.m_rowData.elementAt(nRowIndex + 1);
                this.m_rowData.setElementAt(currentObj, nRowIndex + 1);
                this.m_rowData.setElementAt(previousObj, nRowIndex);
            }
            this.updateRouteOrder();
            this.fireTableDataChanged();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Class getColumnClass(int nColumnIndex) {
        return String.class;
    }

    public int getColumnCount() {
        return 3;
    }

    public String getColumnName(int nColumnIndex) {
        switch (nColumnIndex) {
            case 0: {
                return VWResource.s_nameStr;
            }
            case 1: {
                return VWResource.s_destinationStepStr;
            }
            case 2: {
                return VWResource.s_conditionStr;
            }
        }
        return null;
    }

    public int getRowCount() {
        if (this.m_rowData != null) {
            return this.m_rowData.size();
        }
        return 0;
    }

    public Object getValueAt(int nRowIndex, int nColumnIndex) {
        if (this.m_rowData == null || nRowIndex < 0 || nRowIndex > this.m_rowData.size()) {
            return null;
        }
        try {
            VWRouteDefinition routeDef = (VWRouteDefinition)this.m_rowData.elementAt(nRowIndex);
            switch (nColumnIndex) {
                case 0: {
                    return VWRouteListCellRenderer.toString(routeDef);
                }
                case 1: {
                    return routeDef.getDestinationStep().getName();
                }
                case 2: {
                    String conditionStr = routeDef.getCondition();
                    if (conditionStr == null) {
                        conditionStr = VWResource.s_true;
                    }
                    return conditionStr;
                }
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
        return null;
    }

    public boolean isCellEditable(int nRowIndex, int nColumnIndex) {
        return false;
    }

    private void updateRouteOrder() {
        try {
            int[] nRouteIds = new int[this.m_rowData.size()];
            for (int i = 0; i < this.m_rowData.size(); ++i) {
                nRouteIds[i] = ((VWRouteDefinition)this.m_rowData.elementAt(i)).getRouteId();
            }
            this.m_currentMapNode.reorderRoutes(nRouteIds);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

